# Provenance Snapshot Extension

Browser extension for one-click authenticated web capture with cryptographic provenance.

## What It Does

1. Click extension on any authenticated page
2. Cookies encrypted → pushed to GitHub secret
3. Triggers workflow → browser replays session → captures screenshot
4. GitHub attestation proves you captured this page

## Install

1. Go to `chrome://extensions`
2. Enable "Developer mode"
3. Click "Load unpacked" → select this folder

## Configure

- **Repository**: Your archive repo (e.g. `username/my-archive`)
- **PAT**: GitHub token with `repo` + `workflow` scopes

## Archive Repo Setup

Use the template in `../archive-repo-template/` or create your own with:

```yaml
# .github/workflows/capture.yml
on:
  workflow_dispatch:
    inputs:
      url: { required: true, type: string }
      secret_name: { required: true, type: string }
```

See the template for full workflow.

## Files

- `manifest.json` - Extension config (Manifest v3)
- `popup.html/js` - UI
- `service-worker.js` - GitHub API + encryption
- `lib/` - tweetnacl for sealed box encryption
